/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.dialogs.InputMessageDialog;
import com.aptana.ui.util.UIUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultipleInputMessageDialog
extends InputMessageDialog {
    private static final int MIN_MESSAGE_WIDTH = 250;
    private ObjectNode userInput;
    private ObjectNode response;
    private JsonNode questionsNode;

    public MultipleInputMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public MultipleInputMessageDialog(JsonNode questionNode, String dialogTitle, String dialogMessage) {
        super(UIUtils.getDisplay().getActiveShell(), dialogTitle, null, dialogMessage, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.questionsNode = questionNode;
        this.userInput = JsonNodeFactory.instance.objectNode();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createMessageArea(composite);
        this.createInput(composite);
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        Control control = super.createMessageArea(composite);
        if (this.message != null) {
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(250), -1).applyTo((Control)this.messageLabel);
        }
        return control;
    }

    private void createInput(Composite composite) {
        for (JsonNode question : this.questionsNode) {
            ArrayList<Object> input = new ArrayList<Object>(1);
            new Label(composite, 0);
            Composite parent = new Composite(composite, 0);
            parent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).equalWidth(false).create());
            Label label = new Label(parent, 0);
            String lblTxt = question.path("message").asText();
            label.setText(lblTxt);
            Point requiredSize = label.computeSize(-1, -1);
            int minSize = this.convertHorizontalDLUsToPixels(80);
            if (requiredSize.x > minSize) {
                minSize = requiredSize.x;
            }
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).hint(minSize, -1).applyTo((Control)label);
            Composite valueComp = new Composite(parent, 0);
            valueComp.setLayout((Layout)new FillLayout(256));
            JsonNode choices = question.path("choices");
            ArrayNode values = JsonNodeFactory.instance.arrayNode();
            if (!choices.isArray()) {
                values.add(choices);
            } else {
                values = (ArrayNode)choices;
            }
            String inputType = question.path("type").asText();
            String responseKey = question.path("name").asText();
            if ("input".equals(inputType) || "password".equals(inputType)) {
                int flags = 2048;
                if ("password".equals(inputType)) {
                    flags |= 0x400000;
                }
                Iterator t = new Text(valueComp, flags);
                input.add(t);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(this.convertHorizontalDLUsToPixels(160), 25).applyTo((Control)valueComp);
            } else if ("checkbox".equals(inputType)) {
                for (JsonNode value : values) {
                    Button b = new Button(valueComp, 32);
                    b.setText(value.asText());
                    input.add(b);
                }
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)valueComp);
            } else if ("list".equals(inputType)) {
                Combo l = new Combo(valueComp, 8);
                ComboViewer combo = new ComboViewer(l);
                input.add(combo);
                combo.setContentProvider((IContentProvider)new ArrayContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        if (inputElement instanceof ArrayNode) {
                            ArrayNode arrayNode = (ArrayNode)inputElement;
                            Object[] names = new JsonNode[arrayNode.size()];
                            int i = 0;
                            for (JsonNode node : arrayNode) {
                                names[i++] = node;
                            }
                            return names;
                        }
                        return super.getElements(inputElement);
                    }
                });
                combo.setInput((Object)values);
                combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof ObjectNode) {
                            String name = ((ObjectNode)element).path("name").asText();
                            if (StringUtil.isEmpty((String)name)) {
                                return ((ObjectNode)element).asText();
                            }
                            return name;
                        }
                        if (element instanceof JsonNode) {
                            return ((JsonNode)element).asText();
                        }
                        return element.toString();
                    }
                });
                JsonNode defaultValue = question.path("default");
                if (defaultValue != null && values instanceof ArrayNode) {
                    ArrayNode arrayNode = values;
                    for (JsonNode node : arrayNode) {
                        if (!ObjectUtil.areEqual((Object)node.get("value").textValue(), (Object)defaultValue.textValue())) continue;
                        combo.setSelection((ISelection)new StructuredSelection((Object)node));
                        break;
                    }
                } else {
                    combo.setSelection((ISelection)new StructuredSelection((Object)values.get(0)));
                }
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)valueComp);
            } else if ("confirm".equals(inputType)) {
                input.add(Boolean.TRUE);
                this.setButtonLabels(new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
            }
            this.userInput.putPOJO(responseKey, input);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.response = JsonNodeFactory.instance.objectNode();
            Iterator iterator = this.userInput.fieldNames();
            block0: while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode value = this.userInput.path(fieldName);
                if (!(value instanceof POJONode)) {
                    return;
                }
                Object controls = ((POJONode)value).getPojo();
                if (!(controls instanceof List)) {
                    return;
                }
                List input = (List)controls;
                Object firstElement = CollectionsUtil.getFirstElement((List)input);
                if (firstElement instanceof Boolean) {
                    this.response.put(fieldName, (Boolean)firstElement);
                    continue;
                }
                if (firstElement instanceof Text) {
                    this.response.put(fieldName, ((Text)firstElement).getText());
                    continue;
                }
                if (firstElement instanceof Button) {
                    for (Object b : input) {
                        if (!((Button)b).getSelection()) continue;
                        this.response.put(fieldName, ((Button)b).getText());
                        continue block0;
                    }
                    continue;
                }
                if (firstElement instanceof ComboViewer) {
                    Object selectedElement;
                    ISelection selection = ((ComboViewer)firstElement).getSelection();
                    if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || !((selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof JsonNode)) continue;
                    this.response.put(fieldName, ((JsonNode)selectedElement).path("value").asText());
                    continue;
                }
                if (!(firstElement instanceof Boolean)) continue;
                this.response.put(fieldName, Boolean.TRUE);
            }
        }
        super.buttonPressed(buttonId);
    }

    public Object getValue() {
        return this.response;
    }
}

